/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.spell.game;

import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.DanmakuHelper;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.ItemDanmakuEntity;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.ItemLaserEntity;
import dev.xkmc.youkaishomecoming.content.spell.mover.AttachedMover;
import dev.xkmc.youkaishomecoming.content.spell.mover.RectMover;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.ActualSpellCard;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.CardHolder;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.Ticker;
import dev.xkmc.youkaishomecoming.init.registrate.YHDanmaku;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

@SerialClass
public class MarisaSpell
extends ActualSpellCard {
    @SerialClass.SerialField
    private int cooldown;

    @Override
    public void tick(CardHolder holder) {
        boolean r1;
        super.tick(holder);
        Vec3 target = holder.target();
        Vec3 vec = holder.targetVelocity();
        if (target == null) {
            this.cooldown = 0;
            return;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        if (vec == null) {
            return;
        }
        Vec3 cen = holder.center();
        double dist = cen.m_82554_(target);
        boolean far = dist > 32.0;
        boolean close = dist < 8.0;
        boolean fast = vec.m_165924_() > 0.7;
        boolean r0 = holder.random().m_188500_() < 0.3;
        boolean bl = r1 = holder.random().m_188500_() < 0.3;
        if (!r0 && (close || r1 || far && !fast)) {
            this.addTicker(new MasterSpark(target.m_82546_(cen).m_82541_()));
            this.cooldown = 100;
        } else if (far && fast || r0) {
            this.addTicker(new EarthLight());
            this.cooldown = 100;
        } else {
            this.addTicker(new BlackHole());
            this.cooldown = 100;
        }
    }

    @SerialClass
    public static class MasterSpark
    extends Ticker<MarisaSpell> {
        @SerialClass.SerialField
        private Vec3 target;

        public MasterSpark() {
        }

        public MasterSpark(Vec3 vec) {
            this.target = vec;
        }

        @Override
        public boolean tick(CardHolder holder, MarisaSpell card) {
            if (this.target == null) {
                return true;
            }
            Vec3 cen = holder.center();
            if (this.tick == 0) {
                ItemLaserEntity e = holder.prepareLaser(1, cen, this.target, 80.0f, YHDanmaku.Laser.LASER, DyeColor.YELLOW);
                e.setupTime(20, 1, 1, 1);
                e.mover = new AttachedMover();
                holder.shoot(e);
            }
            if (this.tick > 20) {
                int i;
                Vec3 tar = holder.target();
                if (tar != null) {
                    double maxMove = 0.02;
                    Vec3 db = tar.m_82546_(cen).m_82541_();
                    double dist = this.target.m_82554_(db);
                    double perc = dist < maxMove ? 1.0 : maxMove / dist;
                    this.target = this.target.m_165921_(db, perc);
                }
                RandomSource rand = holder.random();
                DanmakuHelper.Orientation o = DanmakuHelper.getOrientation(this.target);
                for (i = 0; i < 20; ++i) {
                    Vec3 pos = cen.m_82549_(this.target.m_82490_((double)i * 1.4 + 2.0));
                    double x = rand.m_188500_() * 30.0 - 15.0;
                    double y = rand.m_188500_() * 30.0 - 15.0;
                    Vec3 vec = o.rotateDegrees(x, y);
                    double v = rand.m_188500_() + 2.0;
                    ItemDanmakuEntity e = holder.prepareDanmaku(40, vec.m_82490_(v), YHDanmaku.Bullet.STAR, DyeColor.WHITE);
                    e.m_146884_(pos);
                    holder.shoot(e);
                }
                for (i = 0; i < 10; ++i) {
                    double x = rand.m_188500_() * 120.0 - 60.0;
                    double y = rand.m_188500_() * 120.0 - 60.0;
                    Vec3 vec = o.rotateDegrees(x, y);
                    double v = rand.m_188500_() * 0.3 + 0.6;
                    ItemDanmakuEntity e = holder.prepareDanmaku(40, vec.m_82490_(v), YHDanmaku.Bullet.SPARK, DyeColor.YELLOW);
                    e.m_146884_(cen);
                    holder.shoot(e);
                }
            }
            super.tick(holder, card);
            return this.tick > 100;
        }
    }

    @SerialClass
    public static class EarthLight
    extends Ticker<MarisaSpell> {
        @Override
        public boolean tick(CardHolder holder, MarisaSpell card) {
            Vec3 tar = holder.target();
            if (tar == null) {
                return true;
            }
            RandomSource rand = holder.random();
            for (int i = 0; i < 2; ++i) {
                double x = rand.m_188583_() * 10.0;
                double z = rand.m_188583_() * 10.0;
                Vec3 pos = tar.m_82520_(x, 0.0, z);
                BlockPos air = BlockPos.m_274446_((Position)pos);
                BlockPos ground = holder.self().m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, air);
                if (ground.m_123342_() < air.m_123342_() - 20) {
                    pos = pos.m_82520_(0.0, -20.0, 0.0);
                } else if (ground.m_123342_() < air.m_123342_()) {
                    pos = new Vec3(pos.f_82479_, (double)(ground.m_123342_() - 1), pos.f_82481_);
                }
                Vec3 dir = new Vec3(rand.m_188583_(), 5.0, rand.m_188583_()).m_82541_();
                DyeColor color = rand.m_188499_() ? DyeColor.RED : DyeColor.BLUE;
                ItemLaserEntity e = holder.prepareLaser(60, pos, dir, 80.0f, YHDanmaku.Laser.LASER, color);
                holder.shoot(e);
            }
            super.tick(holder, card);
            return this.tick > 100;
        }
    }

    @SerialClass
    public static class BlackHole
    extends Ticker<MarisaSpell> {
        private static final DyeColor[] COLOR = new DyeColor[]{DyeColor.RED, DyeColor.YELLOW, DyeColor.GREEN, DyeColor.CYAN, DyeColor.BLUE};
        private static final double W0 = 7.0;
        private static final double V0 = 0.2;
        private static final double W1 = -4.0;
        private static final double ACC = 0.05;
        private static final double VEC = 0.8;

        @Override
        public boolean tick(CardHolder holder, MarisaSpell card) {
            Vec3 cen = holder.center();
            Vec3 tar = holder.target();
            if (tar != null && tar.f_82480_ > cen.f_82480_) {
                cen = cen.m_82520_(0.0, tar.f_82480_ - cen.f_82480_, 0.0);
            }
            cen = cen.m_82520_(0.0, 24.0, 0.0);
            DanmakuHelper.Orientation o = DanmakuHelper.getOrientation(new Vec3(1.0, 0.0, 0.0));
            Vec3 acc = new Vec3(0.0, -0.05, 0.0);
            for (int i = 0; i < 5; ++i) {
                for (int t = 0; t < 3; ++t) {
                    Vec3 pos = cen.m_82549_(o.rotateDegrees((double)this.tick * 7.0 + (double)(72 * i) + (double)(24 * t)).m_82490_((double)this.tick * 0.2));
                    for (int j = 0; j < 5; ++j) {
                        double v = 0.35 + (double)t * 0.2 + Math.sin((double)this.tick * 0.1 + (double)i) * 0.15;
                        Vec3 dir = o.rotateDegrees((double)this.tick * -4.0 + (double)(72 * j) + (double)(24 * t)).m_82490_(v * 0.8);
                        ItemDanmakuEntity e = holder.prepareDanmaku(40, dir, YHDanmaku.Bullet.SPARK, COLOR[i]);
                        e.m_146884_(pos);
                        e.mover = new RectMover(pos, dir, acc);
                        holder.shoot(e);
                    }
                }
            }
            super.tick(holder, card);
            return this.tick > 100;
        }
    }
}

